/*  Prüft die Einträge der Tabelle "scheduling.resource_timeline" vom Typ "task.blocktime" auf logische Inkonsistenzen.
    Diese Funktion wird üblicherweise als Unterfunktion der DB-Funktion "scheduling.resource_timeline__validate_block" gerufen.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__validate_block_task_blocktime', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__validate_block_task_blocktime(
    _block scheduling.resource_timeline
) RETURNS jsonb AS $$
DECLARE
    _ksvba_id int := context_id FROM scheduling.resource WHERE id = _block.ti_resource_id and context = 'ksvba';

    _issues jsonb := '{ "has_issues": false, "issues":[] }';
BEGIN
    -- Sicher gehen, dass hier wirklich ein Eintrag vom Typ "task.blocktime" validiert wird.
    IF ( _block.ti_type <> 'task.blocktime' ) THEN
        RAISE EXCEPTION 'invalid block type, id % is not of type task.blocktime', _block.ti_id;
    END IF;

    -- Ein Task.Blocktime-Eintrag hat immer eine Belegung von 1.
    IF ( _block.ti_usage <> 1 ) THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"load is not equal 1"' );
    END IF;

    -- NOTE: Hier den nächsten Blocke auskommentieren und den vorherigen Block löschen, falls für die Task.Blocktime doch partial load zugelassen werden soll. Dann muss aber auch der CI-Test 848 angepasst werden.
    -- Ein Task-Eintrag hat immer eine Belegung größer 0 und kleiner gleich 1.
    -- IF NOT( _block.ti_usage <@ '(0,1]'::numrange ) THEN
    --     _issues := jsonb_set( _issues, '{has_issues}', 'true' );
    --     _issues := jsonb_insert( _issues, '{ issues, 0 }', '"load outside allowed range"' );
    -- END IF;

    -- Der Beginn des Task.Blocktime-Eintrag liegt nie vor dem Start der Arbeitszeit.
    IF (
      _block.ti_date_start::time < (scheduling.ksvba__get_shifttimes( _ksvba_id ))[1]
    ) THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"start before resource shift hours"' );
    END IF;

    -- Das Ende des Task.Blocktime-Eintrag liegt nie nach dem Ende der Arbeitszeit.
    IF (
      _block.ti_date_end::time > (scheduling.ksvba__get_shifttimes( _ksvba_id ))[2]
    ) THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"end after resource shift hours"' );
    END IF;

    -- Es kann keinen Task.Blocktime-Eintrag geben, wenn die referenzierte Ressource gesperrt ist.
    -- TODO: Prüfen, ist das wirklich so? Wenn nein, auch in scheduling.resource_timeline__validate_block_task() ändern. Bei ja, prüfen macht die Prüfung auch beim "task.blocktime"-Blöcken sinn?
    IF
        k.ks_sperr
        FROM ksv k
        JOIN ksvba ba ON k.ks_id = ba.ksb_ks_id
        WHERE ba.ksb_id = _ksvba_id
    THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"resource locked"' );
    END IF;

    -- Der Task.Blocktime-Eintrag liegt nie an einem arbeitsfreien Tag.
    IF (
          extract( dow from _block.ti_date_start )
        <> all( scheduling.ksvba__get_workingdays( _ksvba_id ) )
    ) THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"not a working day"' );
    END IF;

    -- Der Task.Blocktime-Eintrag beginnt immer nach dem Ende des letzten zugehörigen Task- bzw. Buffer-Eintrags.
    IF EXISTS(
              SELECT true
              FROM scheduling.resource_timeline
              WHERE
                        ti_type IN ( 'task', 'task.buffer' )
                    AND ti_a2_id = _block.ti_a2_id
                    AND ti_date_end > _block.ti_date_start
    ) THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"start before end of its matching task block"' );
    END IF;

    -- Ein Task.Blocktime-Eintrag hat immer mindestens einen zugehörigen Task oder Buffer-Eintrag.
    IF NOT EXISTS(
                  SELECT true
                  FROM scheduling.resource_timeline
                  WHERE
                            ti_type IN ( 'task', 'task.buffer' )
                        AND ti_a2_id = _block.ti_a2_id
                        AND ti_resource_id = _block.ti_resource_id
    ) THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"no matching task block"' );
    END IF;

    -- raise exception '%', _issues;

    RETURN _issues;

END $$ language plpgsql;
